package gov.va.med.mhv.usermgmt.service;

import junit.framework.TestCase;

import org.tigris.atlas.messages.Messages;
import org.tigris.atlas.service.EntityServiceResponse;
import org.tigris.atlas.service.ServiceResponse;

import gov.va.med.mhv.usermgmt.service.delegate.EntityMaintenanceServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.FacilityServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.transfer.Facility;
import gov.va.med.mhv.usermgmt.transfer.FacilityInfo;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.util.PatientCorrelationStatusUtils;

public class TestFacilityInfoService extends TestCase {
    
    private static final String stationNumber = "TESTNUM";

    private EntityMaintenanceServiceDelegate serviceDelegate;
    private FacilityServiceDelegate facilityService;
    private FacilityInfo facilityInfo = null;
    private Patient patient = null;
    
    /**
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();

        serviceDelegate = ServiceDelegateFactory
            .createEntityMaintenanceServiceDelegate();
        facilityService = ServiceDelegateFactory
            .createFacilityServiceDelegate();
        createFacilityInfo();
        createPatient();
    }
    
    protected void createFacilityInfo() throws Exception {
        
        facilityInfo = TransferObjectFactory.createFacilityInfo();
        facilityInfo.setStationNumber(stationNumber);
        facilityInfo.setTreatment(Boolean.FALSE);
        facilityInfo.setActive(Boolean.TRUE);
        facilityInfo.setName(getClass().getName());
        facilityInfo.setIpAddess("255.255.255.255");
        facilityInfo.setDomainName("server123.server12.domain");
        facilityInfo.setPort(new Integer(7001));
        facilityInfo.setTimeout(new Long(0000));
        FacilityInfoServiceResponse response = serviceDelegate.save(
            facilityInfo);
        facilityInfo = response.getFacilityInfo();
        assertNoMessages(response);

    }
    
    protected void createPatient() throws Exception {
        // create a patient and associate it with the facility:
        patient = TransferObjectFactory.createPatient();
        patient.setIcn("some icn value");
        patient.setCorrelationStatus(PatientCorrelationStatusUtils.UNCORRELATED);

        // create facility and associate it with the facility info
        Facility facility = TransferObjectFactory.createFacility();
        facility.setFacilityInfo(facilityInfo);
        facility.setName(stationNumber);
        patient.addFacility(facility);
        PatientServiceResponse patientResponse = serviceDelegate.save(patient);
        assertNoMessages(patientResponse);
        patient = patientResponse.getPatient();
    }

    /**
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();

        if (patient != null) {
            patient.setFacilitys(null);
            PatientServiceResponse response = serviceDelegate.delete(patient.
                getPatientPK());
            assertNoMessages(response);
        }
        if (facilityInfo != null) {
            FacilityInfoServiceResponse response = serviceDelegate.delete(
                facilityInfo.getFacilityInfoPK());
            assertNoMessages(response);
        }

        serviceDelegate = null;
        facilityService = null;
    }

    public void testQueryByStationNumber() throws Exception {
        FacilityInfoServiceResponse queryResponse = facilityService.
            queryFacilityInfoByStationNumber(stationNumber);
        assertNoMessages(queryResponse);
        assertNotNull("Facility '" + stationNumber 
            + "' should have been returned!", queryResponse.getFacilityInfo());

    }

    public void testQueryByStationNumberWithBadNumber() throws Exception {
        FacilityInfoServiceResponse queryResponse = facilityService.
            queryFacilityInfoByStationNumber(new String("_______"));
        assertNoMessages(queryResponse);
        assertNull("No facility should have been returned!", queryResponse.
            getFacilityInfo());
    }

    public void testQueryByPatient() throws Exception {
        FacilityInfoCollectionServiceResponse collectionResponse = 
            facilityService.queryFacilityInfoByPatient(patient);
        assertNoMessages(collectionResponse);
        assertEquals("FacilityInfo '" + stationNumber
            + "' should have been returned!", 1, 
            collectionResponse.getFacilityInfos().size());
    }

    private void assertNoMessages(EntityServiceResponse response) {
        assertNoMessages((ServiceResponse) response);
        if (response.getEntity() != null) {
            Messages messages = response.getEntity().getAllMessages(); 
            assertEquals("No messages should have been returned" + messages.
                getErrorMessages(), 0, messages.getErrorMessageCount());
        }
    }

    private void assertNoMessages(ServiceResponse response) {
        assertEquals("No messages should have been returned"
            + response.getMessages().getErrorMessages(), 0, 
            response.getMessages().getErrorMessageCount());
    }

}
